﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>

<script runat="server">

    public class _SrInfo : SerializableContextBase {
        public _SrInfo(Context context) : base(context) {
        }

        bool kosztyPracodawcy = false;
        [Priority(10)]
        [Caption("Koszty pracodawcy")]
        public bool KosztyPracodawcy {
            get { return kosztyPracodawcy; }
            set {
                kosztyPracodawcy = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    _SrInfo srinfo;
    [SettingsContext]
    public _SrInfo SrInfo {
        set { srinfo = value; }
    }

    public class _Info : ContextBase {
        public _Info(Context context) : base(context) {
        }

        int iloscKopii = 1;
        [Caption("Ilość kopii rachunku")]
        [Priority(10)]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        bool rachunekUmowa = (wyplataID != 0);
        [Caption("Umowa do rachunku")]
        [Priority(20)]
        public bool RachunekUmowa {
            get { return rachunekUmowa; }
            set {
                rachunekUmowa = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyRachunekUmowa() {
            return (wyplataID != 0);
        }
    }

    _Info info;
    [Context]
    public _Info Info {
        set { info = value; }
    }

    static int wyplataID = 0;
    
    void OnContextLoading(object sender, EventArgs e) {
        try {
            if (Request.QueryString.Get("WyplataID") != string.Empty)
                wyplataID = Convert.ToInt32(Request.QueryString.Get("WyplataID"));
        }
        catch { }
        if (wyplataID != 0) {
            WyplataUmowa wu = (WyplataUmowa)PlaceModule.GetInstance(dc).Wyplaty[wyplataID];
            if (wu != null)
                dc.Context[typeof(WyplataUmowa)] = wu;
        }
    }

    string pozycja = "<tr>" +
        "<td>{0}:</td>" +
        "<td align=\"right\"><b>{1}</b>&nbsp;zł</td>" +
        "<td></td>" +
        "</tr>";
        
	void OnContextLoad(object sender, EventArgs e) {
		Wyplata w = (Wyplata)dc[typeof(Wyplata)];
        WyplataUmowa wu = w as WyplataUmowa;
		Wyplata.PITInfoWorker worker = new Wyplata.PITInfoWorker();
		worker.Wypłata = w;
		int precyzja = PlaceModule.GetInstance(dc).Config.Podatki.Zaokrąglenia.PodstawaOpodatkowania;
		decimal podstawa = Soneta.Tools.Math.Round(worker.Podstawa, precyzja);	
		labelPodstawa.EditValue = podstawa;
	
		Currency brutto = worker.VatBrutto;
		labelBrutto.EditValue = brutto;
		labelBruttoSl.EditValue = brutto;
	
		scGotówka.Visible = w.Gotówka!=0;
		scPrzelew.Visible = w.Inne!=0;
        KosztyPracodawcy.Visible = srinfo.KosztyPracodawcy;

        scDowyplatyBezVat.Visible = !wu.Umowa.PodlegaVAT;
        scVat.Visible = wu.Umowa.PodlegaVAT;
        scDoWyplatyVat.Visible = wu.Umowa.PodlegaVAT;

        Datalabel6.EditValue = GetMiejscowosc(w.PracHistoria);

        string pozycje = string.Empty;
        foreach (WypElement we in w.Elementy)
            if (we.Definicja.Info.Potrącenie)
                pozycje += string.Format(pozycja, we.Definicja.Nazwa, we.Wartosc);
        colPotracenie.EditValue = pozycje;

        Time czas = Time.Empty;
        foreach (ZestawienieUmowy zu in wu.Umowa.Zestawienia.GetIntersectedRows(w.ListaPlac.Okres))
            if (w.ListaPlac.Okres.Contains(zu.Okres))
                czas += zu.Czas;
        ZestawienieGodz.Visible = czas != Time.Empty;
        labelZestawienie.EditValue = czas;

        SectionPPK.Visible = JestPPK(w.ListaPlac, w.ListaPlac.DataWyplaty);

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(w);
        DataRepeater1.DataSource = al;
        
        if (info.RachunekUmowa && wyplataID == 0)
            if (wu != null)
                dc.FollowingReports.Add(new FollowingReport(string.Format("Kadry/umowa zlecenie.aspx?UmowaID={0}", wu.Umowa[wu.Data].ID)));
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }

    private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    static void Msg(object value) {
    }

</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Umowa zlecenie - rachunek</title>
		<META http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaOPracę" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" OnContextLoading="OnContextLoading" TypeName="Soneta.Place.WyplataUmowa, Soneta.KadryPlace" oncontextload="OnContextLoad"></EA:DATACONTEXT>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Place.Wyplata, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak2" runat="server" BreakFirstTimes="False" 
			    ResetPageCounter="True"></ea:PageBreak>
            <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Umowa zlecenie - rachunek" runat="server"></cc1:ReportHeader>
			<font face="Tahoma" size="2">
			<p style="text-align:justify">za prace :
				<ea:datalabel id="Datalabel1" runat="server" DataMember="Umowa.Tytul"></ea:datalabel><br>
				wykonane w ramach umowy zlecenia numer
				<ea:datalabel id="Datalabel2" runat="server" DataMember="Umowa.Numer"></ea:datalabel>&nbsp;z 
				dnia
				<ea:datalabel id="Datalabel3" runat="server" DataMember="Umowa.Data"></ea:datalabel><br/>
				na kwotę
				<ea:datalabel id="labelBrutto" runat="server" Format="{0:u}"></ea:datalabel>
				(słownie:
				<ea:datalabel id="labelBruttoSl" runat="server" Format="{0:t}"></ea:datalabel>).
			</p>
			<p style="text-align:justify">
                <ea:Section ID="ZestawienieGodz" runat="server">
                    Oświadczam, że liczba godzin wykonania zlecenia wyniosła
                    <ea:datalabel id="labelZestawienie" runat="server"></ea:datalabel>.<br />
                </ea:Section>
                Oświadczam, że pracę
				<ea:datalabel id="DataLabel41" runat="server" DataMember="Pracownik.Last.Plec" Bold="False">
					<VALUESMAP>
						<EA:VALUESPAIR Value="wykonałam" Key="Kobieta"></EA:VALUESPAIR>
						<EA:VALUESPAIR Value="wykonałem" Key="Mężczyzna"></EA:VALUESPAIR>
					</VALUESMAP>
				</ea:datalabel>&nbsp;osobiście.
				<table id="Table1" cellSpacing="0" width="100%" style="font-size: 10pt; font-family: tahoma">
					<tbody>
						<tr>
							<td width="50%"><ea:datalabel id="Datalabel6" runat="server"></ea:datalabel>, 
								dnia
								<ea:datalabel id="Datalabel7" runat="server" DataMember="Data"></ea:datalabel></td>
							<td>
								<p align="center">. . . . . . . . . . . . . . . . . . . .
									<br>
									(zleceniobiorca)
								</p>
							</td>
						</tr>
					</tbody>
				</table>
				<br>
			</p>
			Stwierdzenie odbioru pracy:
			<table id="Table2" cellSpacing="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
				<tbody>
					<tr>
						<td width="50%">Praca została wykonana i przyjęta</td>
						<td>
							<p align="center">. . . . . . . . . . . . . . . . . . . .
								<br>
								(zleceniodawca)
							</p>
						</td>
					</tr>
				</tbody>
			</table>
			<br/>
			<font size="3">
				<p align="center"><b>Rozliczenie należności</b></p>
			</font>
			<p style="text-align:justify">
	        <table id="Table10" cellSpacing="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
	        <tbody>
    	    <tr>
            <td width="65%" valign="top">
		        <table id="Table3" cellSpacing="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
			        <tbody>
				        <tr>
					        <td width="65%">Kwota wynagrodzenia brutto:</td>
					        <td align="right" width="20%"><ea:datalabel id="Datalabel36" runat="server" DataMember="Workers.PITInfo.VatBrutto" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td align="right" width="15%"></td>
				        </tr>
                        <tr>
					        <td width="65%">Przychód zw. z podatku dla os. do 26 r.:</td>
					        <td align="right" width="20%"><ea:datalabel id="Datalabel10" runat="server" DataMember="Workers.PITInfo.Przychod26" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td align="right" width="15%"></td>
				        </tr>
                        <ea:Section ID="scVat" runat="server" Width="100%">
				        <tr>
					        <td>Podatek VAT:</td>
					        <td align="right"><ea:datalabel id="Datalabel29" runat="server" DataMember="Workers.PITInfo.VatPodatek" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td align="right"><ea:datalabel id="Datalabel39" runat="server" DataMember="Workers.PITInfo.VatStawka" Format="{0:n}"></ea:datalabel></td>
				        </tr>
				        <tr>
					        <td>Kwota wynagrodzenia netto:</td>
					        <td align="right"><ea:datalabel id="Datalabel38" runat="server" DataMember="Workers.PITInfo.Brutto" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
                        </ea:Section>
				        <tr>
					        <td>Składka na ubezpieczenie emerytalne:</td>
					        <td align="right"><ea:datalabel id="Datalabel31" runat="server" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Prac" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Składka na ubezpieczenie rentowe:</td>
					        <td align="right"><ea:datalabel id="Datalabel32" runat="server" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Prac" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Składka na ubezpieczenie chorobowe:</td>
					        <td align="right"><ea:datalabel id="Datalabel37" runat="server" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Prac" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Koszty uzyskania:</td>
					        <td align="right"><ea:datalabel id="Datalabel28" runat="server" DataMember="Workers.PITInfo.Koszty" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Kwota do opodatkowania (po zaokrągleniu):</td>
					        <td align="right"><ea:datalabel id="labelPodstawa" runat="server" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Składka na ubezpieczenie zdrowotne:</td>
					        <td align="right"><ea:datalabel id="Datalabel33" runat="server" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
				        <tr>
					        <td>Podatek dochodowy:</td>
					        <td align="right"><ea:datalabel id="Datalabel30" runat="server" DataMember="Workers.PITInfo.ZalFIS" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
                         <ea:Section ID="SectionPPK" runat="server" Width="100%">
                        <tr>
					        <td>Składka na PPK:</td>
					        <td align="right"><ea:datalabel id="Datalabel11" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.Pracownika" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
                         </ea:Section>
                        <ea:datalabel id="colPotracenie" runat="server"></ea:datalabel>
                        <ea:Section ID="scDoWyplatyVat" runat="server" Width="100%">
                        <tr>
					        <td>Do wypłaty (w tym podatek VAT):</td>
					        <td align="right"><ea:datalabel id="Datalabel34" runat="server" DataMember="Wartosc.Value" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
                        </ea:Section>
                        <ea:Section ID="scDowyplatyBezVat" runat="server" Width="100%">
                        <tr>
					        <td>Do wypłaty:</td>
					        <td align="right"><ea:datalabel id="Datalabel15" runat="server" DataMember="Wartosc.Value" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
					        <td></td>
				        </tr>
                        </ea:Section>
			        </tbody>
		        </table>
            </td>
            <td width="35%" valign="top">
                <ea:Section ID="KosztyPracodawcy" runat="server">
		        <table id="Table11" cellSpacing="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
			        <tbody>
				        <tr>
					        <td width="65%"><b>Koszty pracodawcy:</b></td>
					        <td align="right" width="35%"></td>
				        </tr>
				        <tr>
					        <td>Skł. emer:</td>
					        <td align="right"><ea:datalabel id="Datalabel4" runat="server" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Firma" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
				        </tr>
				        <tr>
					        <td>Skł. rent:</td>
					        <td align="right"><ea:datalabel id="Datalabel5" runat="server" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Firma" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
				        </tr>
				        <tr>
					        <td>Skł. wyp:</td>
					        <td align="right"><ea:datalabel id="Datalabel26" runat="server" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Firma" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
				        </tr>
				        <tr>
					        <td>Skł. FP:</td>
					        <td align="right"><ea:datalabel id="Datalabel27" runat="server" DataMember="Workers.WyplataSkładki.Razem.FP.Firma" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
				        </tr>
				        <tr>
					        <td>Skł. FGŚP:</td>
					        <td align="right"><ea:datalabel id="Datalabel43" runat="server" DataMember="Workers.WyplataSkładki.Razem.FGSP.Firma" Format="{0:n}"></ea:datalabel>&nbsp;zł</td>
				        </tr>
                    </tbody>
                </table>
                </ea:Section>
            </td>
            </tr>
            </tbody>
            </table>
			</p>
            <ea:Section ID="scGotówka" runat="server" Width="100%">
				<P>
				<P style="text-align:justify">Pokwitowanie wypłaty:
					<BR>
					Kwituję odbiór kwoty
					<ea:datalabel id="Datalabel25" runat="server" DataMember="Gotówka" Format="{0:u}"></ea:datalabel>&nbsp;(słownie:
					<ea:datalabel id="Datalabel35" runat="server" DataMember="Gotówka" Format="{0:t}"></ea:datalabel>).
				</P>
				<TABLE id="Table4" cellSpacing="0" width="100%" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD width="50%">
							<P align="center">. . . . . . . . . . . . . . . . . . . .
								<BR>
								(data)
							</P>
						</TD>
						<TD>
							<P align="center">. . . . . . . . . . . . . . . . . . . .
								<BR>
								(podpis)
							</P>
						</TD>
					</TR>
				</TABLE>
				<P></P>
			</ea:Section>
            <ea:Section ID="scPrzelew" runat="server" Width="100%">
				<P style="text-align:justify">Płatność na kwotę&nbsp;
					<ea:datalabel id="Datalabel40" runat="server" DataMember="Inne" Format="{0:u}"></ea:datalabel>&nbsp;(słownie:
					<ea:datalabel id="Datalabel42" runat="server" DataMember="Inne" Format="{0:t}"></ea:datalabel>) 
					zostanie zrealizowana przelewem.
				</P>
			</ea:Section>
			<br/>
            </font>
            <ea:PageBreak id="PageBreak1" runat="server" Required="false"></ea:PageBreak>
			<font face="Tahoma" size="2">
			<font size="3">
				<p align="center"><b>Oświadczenie Zleceniobiorcy dla celów podatkowych</b></p>
			</font>
			<p style="text-align:justify">
				<table id="Table5" cellSpacing="0" width="100%" border="0" style="font-size: 10pt; font-family: tahoma">
					<tbody>
						<tr>
							<td width="50%">Nazwisko:
								<ea:datalabel id="Datalabel8" runat="server" DataMember="PracHistoria.Nazwisko"></ea:datalabel></td>
							<td>Imiona:
								<ea:datalabel id="Datalabel9" runat="server" DataMember="PracHistoria.Imie"></ea:datalabel>,
								<ea:datalabel id="Datalabel13" runat="server" DataMember="PracHistoria.ImieDrugie"></ea:datalabel></td>
						</tr>
						<tr>
							<td colSpan="2">Data i miejsce urodzenia:
								<ea:datalabel id="Datalabel12" runat="server" DataMember="PracHistoria.Urodzony.Data"></ea:datalabel>,
								<ea:datalabel id="Datalabel16" runat="server" DataMember="PracHistoria.Urodzony.Miejsce"></ea:datalabel></td>
						</tr>
						<tr>
							<td>PESEL:
								<ea:datalabel id="Datalabel14" runat="server" DataMember="PracHistoria.PESEL"></ea:datalabel></td>
							<td>&nbsp;</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p style="text-align:justify">Adres zamieszkania (województwo – gmina / dzielnica) ul.
				<ea:datalabel id="Datalabel17" runat="server" DataMember="PracHistoria.Adres.Ulica"></ea:datalabel>, 
				nr domu
				<ea:datalabel id="Datalabel18" runat="server" DataMember="PracHistoria.Adres.NrDomu"></ea:datalabel>, 
				nr mieszkania
				<ea:datalabel id="Datalabel19" runat="server" DataMember="PracHistoria.Adres.NrLokalu"></ea:datalabel>,&nbsp;miejscowość
				<ea:datalabel id="Datalabel20" runat="server" DataMember="PracHistoria.Adres.Miejscowosc"></ea:datalabel>, 
				kod pocztowy
				<ea:datalabel id="Datalabel22" runat="server" DataMember="PracHistoria.Adres.KodPocztowyS"></ea:datalabel>, 
				poczta
				<ea:datalabel id="Datalabel21" runat="server" DataMember="PracHistoria.Adres.Poczta"></ea:datalabel>.
			</p>
			<p style="text-align:justify">Urząd Skarbowy, w którym składana jest informacja:&nbsp;
				<ea:datalabel id="Datalabel23" runat="server" DataMember="PracHistoria.Podatki.UrzadSkarbowy.Nazwa"></ea:datalabel>,
				<ea:datalabel id="Datalabel24" runat="server" DataMember="PracHistoria.Podatki.UrzadSkarbowy.Adres"></ea:datalabel>.
			</p>
			<p style="text-align:justify">
				<table id="Table6" cellSpacing="0" width="100%" style="font-size: 10pt; font-family: tahoma">
					<tbody>
						<tr>
							<td width="50%">
							</td>
							<td>
								<p align="center">. . . . . . . . . . . . . . . . . . . .
									<br>
									(podpis)
								</p>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p></p>
		</font>
        <cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
        </ea:DataRepeater>
		</form>
	</body>
</HTML>
